function get_lastorder() {

    const contdiv = document.getElementById("lastorders");
    const limit = document.getElementById("limit").value;
    contdiv.innerHTML = '';

    // --- Հարցում ---
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = JSON.parse(xhttp.responseText);

            // ստեղծում է աղյուսակը
            const newtable = new Table(
                "#lastorders",
                [false, false, false],
                ['', '', ''],
                ["number", "text", "data"],
                [{ idorder: "Մուտք N:" }, { supplier: "Մատակարար" }, { amst: "ԱՄՍԹ" }],
                result
            );
        }
    };

    xhttp.open("GET", "lastorder_data.php?limit=" + limit, true);
    xhttp.send();
}

function suppl_data() {

    const contdiv = document.getElementById("suppl_data");
    contdiv.innerHTML = '';

    // --- Հարցում ---
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = JSON.parse(xhttp.responseText);

            // ստեղծում է աղյուսակը
            const newtable = new Table(
                "#suppl_data",
                [false, false],
                ['', ''],
                ["number", "text"],
                [{ idsupplier: "Կոդ" }, { supplier: "Մատակարար" }],
                result
            );

            const table = document.querySelector("#suppl_data table");
            const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

            const supplSet = new Set();
            const datalist = document.getElementById('select_suppllist');
            datalist.innerHTML = '';
            for (let row of rows) {
                const supplier1 = row.cells[2].textContent.trim();

                if (!supplSet.has(supplier1)) {
                    supplSet.add(supplier1);
                    const opt = document.createElement('option');
                    opt.value = supplier1;
                    datalist.appendChild(opt);
                }
            }
        }
    };

    xhttp.open("GET", "suppl_data.php?", true);
    xhttp.send();
}
function order_apranq() {
    const contdiv = document.getElementById("orderapranq");
    const container = document.getElementById("lastorders");
    contdiv.innerHTML = '';

    //const activrows = container.querySelectorAll('tbody tr');
    // const activeRows = document.getElementsByClassName('active-row');
    const activeRows = document.querySelectorAll('#lastorders .active-row');  //վերցնում է հենց lastorders-ի աղյուսակի նշված տողերը

    if (activeRows.length == 1) {
        const cells = activeRows[0].getElementsByTagName('td');
        const ido = cells[1].textContent.trim();
        document.getElementById("ido").value = ido;
        get_orderapranq(ido);
        // Remove active-row class from all rows
        for (let row of activeRows) {
            row.classList.remove('active-row');
        }
    } else {
        alert("Ընտրեք միայն մեկ մուտք");
    }
}

function get_orderapranq(ido) {

    const contdiv = document.getElementById("orderapranq");
    //contdiv.innerHTML = '';

    // --- Հարցում ---
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            //console.log(xhttp.responseText);
            const result = JSON.parse(xhttp.responseText);

            // ստեղծում է աղյուսակը
            const newtable = new Table(
                "#orderapranq",
                [false, false, false, false, true, false, false, false, false, false, false],
                ['none', 'none', 'none', '', '', '', '', '', '', '', ''],
                ["number", "number", "number", "text", "text", "number", "number", "number", "number", "number"],
                [{ id: "ԻԴ" }, { idorder: "ԻԴO" }, { ida: "ԻԴԱ" }, { idapranq: "Կոդ" }, { apranq: "Անվանում" }, { qan: "Քանակ" }, { p0office: "Առք" }, { zexj: "Զեղչ" }, { p0: "Առք" }, { p1: "Գին" }, { vradir: "վրադիր" }],
                result
            );
            get_total();
        }
    };

    xhttp.open("GET", "order_apranq.php?ido=" + ido, true);
    xhttp.send();
}
function suppFilter() {
    const inputSuppl = document.getElementById('select_suppl');
    const table = document.querySelector("#suppl_data table");
    const rows = table?.getElementsByTagName('tbody')[0]?.getElementsByTagName('tr') || [];

    const supplText = inputSuppl.value.toLowerCase().trim();

    for (let row of rows) {
        const suppl = row.cells[2].textContent.trim().toLowerCase();   // Մատակարար
        const matchSuppllist = !supplText || suppl === supplText;

        row.style.display = (matchSuppllist) ? '' : 'none';
    }
}
function filter_suppl() {
    const inputSuppl = document.getElementById('select_suppl');
    const table = document.querySelector("#suppl_data table");
    const rows = table?.getElementsByTagName('tbody')[0]?.getElementsByTagName('tr') || [];
    const supplText = inputSuppl.value.toLowerCase().trim();

    let scrolled = false;
    for (let row of rows) {
        const suppl = row.cells[2].textContent.trim().toLowerCase();

        if (supplText && suppl === supplText) {
            row.classList.add('active-row');

            if (!scrolled) {
                row.scrollIntoView({ behavior: 'smooth', block: 'center' });
                scrolled = true;
            }
        } else {
            row.classList.remove('active-row');
        }
    }
}
function new_order() {
    const row = document.getElementsByClassName('active-row');
    if (row.length == 1) {
        const cells = row[0].getElementsByTagName('td');
        const ids = cells[1].textContent.trim();

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                //const result = JSON.parse(xhttp.responseText);
                get_lastorder();
                row[0].classList.remove('active-row');
                alert(xhttp.responseText);
            }
        }
        xhttp.open("GET", "new_order.php?idsupplier=" + ids, true);
        xhttp.send();
    } else {
        alert("Ընտրեք միայն մեկ մատակարար");
    }
}
function find_apranq(ind) {
    if (ind == 1) {
        const ida = document.getElementById("ida");
        const kod = document.getElementById("idapranq").value;
        const apr = document.getElementById("apranq");
        const p0office = document.getElementById("p0office");
        const zexj = document.getElementById("zexj");
        const p0 = document.getElementById("p0");
        const p1 = document.getElementById("p1");

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const result = JSON.parse(xhttp.responseText);
                if (result.length == 0) {
                    //alert("այդպիսի կոդով ապրանք չկա բազայում");
                    var xhttp2 = new XMLHttpRequest();
                    xhttp2.onreadystatechange = function () {
                        if (this.readyState == 4 && this.status == 200) {
                            const result2 = xhttp2.responseText;
                            console.log(result2);
                            if (result2 == 0) {
                                alert("Չհաջողվեց ավելացնել");
                            } else {
                                alert("Նոր ապրանքը հաջողությամբ ավելացվել է։ ");
                                document.getElementById("ida").value = result2;
                            }
                        }
                    }
                    xhttp2.open("GET", "new_apr.php?idapranq=" + kod, true);
                    xhttp2.send();
                } else {
                    ida.value = result[0].ida;
                    apr.value = result[0].apranq;
                    p0office.value = result[0].p0office;
                    zexj.value = result[0].zexj;
                    p0.value = result[0].p0;
                    p1.value = result[0].p1;
                }
            }
        }
        xhttp.open("GET", "get_order_apranq.php?idapranq=" + kod, true);
        xhttp.send();
    } else {
        const kod = document.getElementById("idapranq").value;
        if (kod == "") {

            document.getElementById('findapr').style.display = 'block';
            const apr = document.getElementById("apranq").value;

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const result = JSON.parse(xhttp.responseText);
                    const contdiv = document.getElementById("findapr_data");
                    contdiv.innerHTML = '';
                    // ստեղծում է աղյուսակը
                    const newtable = new Table(
                        "#findapr_data",
                        [false, false, true, false, false, false, false, false, false],
                        ['', '', '', '', '', '', '', '', ''],
                        ["number", "text", "text", "number", "number", "number", "number", "number"],
                        [{ ida: "ԻԴԱ" }, { idapranq: "Կոդ" }, { apranq: "Անվանում" }, { qan: "Քանակ" }, { p0office: "Առք" }, { zexj: "Զեղչ" }, { p0: "Առք" }, { p1: "Գին" }, { vradir: "Վրադիր" }],
                        result
                    );

                }
            }
            xhttp.open("GET", "get_order_apranq.php?apranq=" + apr, true);
            xhttp.send();
        }
    }
}
function orderapranq_newrow() {
    const ida = document.getElementById("ida").value;
    const idapranq = document.getElementById("idapranq").value;
    const apranq = document.getElementById("apranq").value;
    const qan = document.getElementById("qan").value;
    const p0office = document.getElementById("p0office").value;
    const zexj = document.getElementById("zexj").value;
    const p0 = document.getElementById("p0").value;
    const p1 = document.getElementById("p1").value;
    const ido = document.getElementById("ido").value;


    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {


            if (xhttp.responseText == 0) {
                "Չի հաջողվել ավելացնել";
            } else {
                //update_qan(ida, qan); 
                const id = xhttp.responseText;
                const table = document.querySelector('#orderapranq tbody');
                const tr = document.createElement('tr');


                const count_rows = document.querySelector('#orderapranq .count_rows').innerHTML;
                const count_tr = Number(count_rows.slice(2)) + 1;

                const td1 = document.createElement('td');
                const bt = document.createElement('input');
                bt.type = "button";
                bt.value = count_tr;
                bt.addEventListener('click', (event) => checkRow(event));
                td1.appendChild(bt);
                tr.appendChild(td1);

                const td2 = document.createElement('td');
                td2.textContent = id;
                td2.hidden = true;
                tr.appendChild(td2);

                const tr_data = [idapranq, apranq, qan, p0office, zexj, p0, p1, ""]
                tr_data.forEach((value, index, array) => {
                    const td = document.createElement('td');
                    td.textContent = value;
                    tr.appendChild(td);
                });
                table.appendChild(tr);
                let scrolled = false;
                if (!scrolled) {
                    tr.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    scrolled = true;
                }


                document.getElementById("ida").value = "";
                document.getElementById("idapranq").value = "";
                document.getElementById("apranq").value = "";
                document.getElementById("qan").value = "";
                document.getElementById("p0office").value = "";
                document.getElementById("zexj").value = "";
                document.getElementById("p0").value = "";
                document.getElementById("p1").value = "";

                get_total();
            }
        }
    }
    xhttp.open("GET", "order_apranq_addrow.php?ido=" + ido + "&ida=" + ida + "&apranq=" + apranq + "&qan=" + qan + "&p0office=" + p0office + "&zexj=" + zexj + "&p0=" + p0 + "&p1=" + p1, true);
    xhttp.send();
}
function find_apr() {
    //const row = document.getElementsByClassName('active-row');
    const row = document.querySelectorAll('#findapr_data .active-row');  //վերցնում է հենց findapr_data-ի աղյուսակի նշված տողերը
    if (row.length == 1) {
        const cells = row[0].getElementsByTagName('td');
        const ida = cells[1].textContent.trim();

        document.getElementById("ida").value = cells[1].textContent.trim();;
        document.getElementById("idapranq").value = cells[2].textContent.trim();;
        document.getElementById("apranq").value = cells[3].textContent.trim();;
        document.getElementById("qan").value = cells[4].textContent.trim();;
        document.getElementById("p0office").value = cells[5].textContent.trim();;
        document.getElementById("zexj").value = cells[6].textContent.trim();;
        document.getElementById("p0").value = cells[7].textContent.trim();;
        document.getElementById("p1").value = cells[8].textContent.trim();;
        row[0].classList.remove('active-row');
    } else {
        alert("Ընտրեք միայն մեկ ապրանք");
    }
}
function delete_rows() {
    //const rows = document.getElementsByClassName('active-row');
    const rows = document.querySelectorAll('#orderapranq .active-row');  //վերցնում է հենց orderapranq-ի աղյուսակի նշված տողերը
    if (rows.length > 0) {
        const data = [];
        for (let i = 0; i < rows.length; i++) {
            let cells = rows[i].getElementsByTagName('td');
            let id = cells[1].textContent.trim();
            data.push(Number(id));

            /*    let ida = Number(cells[3].textContent.trim());
                let qanTarb=Number("-" + cells[6].textContent.trim());
            
                console.log(ida);
                update_qan(ida, qanTarb);*/
        }
        console.log(data);

        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const contdiv = document.getElementById("orderapranq");
                contdiv.innerHTML = '';
                const ido = document.getElementById("ido").value;
                get_orderapranq(ido);
                alert(xhttp.responseText);
            }
        }
        xhttp.open("GET", "delete_orderapranq.php?data=" + data, true);
        xhttp.send();

    } else {
        alert("Ընտրեք առնվազն մեկ տող");
    }
}
function new_apr() {
    const idapranq = document.getElementById("new_idapranq").value;
    const apranq = document.getElementById("new_apranq").value;


    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = xhttp.responseText;
            if (result == 0) {
                alert("Չհաջողվեց ավելացնել");
            } else {
                alert("Ապրանքը հաջողությամբ ավելացվել է։");
                document.getElementById("ida").value = ida;
                document.getElementById("idapranq").value = idapranq;
                document.getElementById("apranq").value = apranq;
            }
        }
    }
    xhttp.open("GET", "new_apr.php?idapranq=" + idapranq + "&apranq=" + apranq, true);
    xhttp.send();

}
function checkRow(event) {
    const button = event.currentTarget;
    const rowElement = button.closest('tr');

    //նշել ընթացիկ տողը
    if (rowElement) {
        if (rowElement.classList.contains('active-row')) {
            rowElement.classList.remove('active-row');
        } else {
            rowElement.classList.add('active-row');
        }
        //console.log("Clicked row:", rowElement);
    }
}


// Չենք օգտագործում, մնացորդի կարգավորումը տրիգերներով
function update_apranq_info(ida, apranq, p0office, zexj, p0, p1) {
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = xhttp.responseText;
            console.log(result);

        }
    }
    xhttp.open("GET", "update_apranq_info.php?ida=" + ida + "&apranq=" + apranq + "&p0office=" + p0office + "&zexj=" + zexj + "&p0=" + p0 + "&p1=" + p1, true);
    xhttp.send();
}

function get_total() {
    //    const table = document.getElementById("orderapranq");
    //    const rows = table.querySelectorAll("tbody tr");

    let total_arq = 0;
    let total_vaj = 0;

    const rows = document.querySelectorAll('#orderapranq tbody tr');
    console.log(rows);
    if (rows.length > 0) {
        for (let i = 0; i < rows.length; i++) {
            const cells = rows[i].getElementsByTagName('td');

            const count = parseFloat(cells[6].textContent.trim());
            const p0 = parseFloat(cells[7].textContent.trim());
            const p1 = parseFloat(cells[10].textContent.trim());

            total_arq += count * p0;
            total_vaj += count * p1;
        }
    }
    document.getElementById("sumP0").value = total_arq;
    document.getElementById("sumP1").value = total_vaj;
}
function get_new_code() {
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const result = xhttp.responseText;
            //console.log(result); 
            document.getElementById("idapranq").value = result;
            find_apranq(1);
        }
    }
    xhttp.open("GET", "get_new_code.php?", true);
    xhttp.send();
}
function calcZexj() {
    const p0 = document.getElementById('p0');
    const p0office = document.getElementById('p0office').value;
    const zexj = document.getElementById('zexj').value;

    p0.value = p0office * (1 - zexj / 100);
}
//------------- testing mutq-----------------
/*const form = document.getElementById('productForm');

const barcodeInput = document.getElementById('idapranq');
const nameInput = document.getElementById('apranq');
const quantityInput = document.getElementById('qan');
const price0Input = document.getElementById('p0');
const priceInput = document.getElementById('p1');

const errors = {
    barcode: document.getElementById('barcodeError'),
    name: document.getElementById('nameError'),
    quantity: document.getElementById('quantityError'),
    price0: document.getElementById('price0Error'),
    price: document.getElementById('priceError'),
};

function validateBarcode() {
    const value = barcodeInput.value.trim();
    const numericRegex = /^\d+$/;

    if (value.length < 4 || value.length > 13) {
        errors.barcode.textContent = "Շտրիխ կոդը պետք է լինի 4-ից 13 նիշ երկարությամբ։";
        return false;
    }
    if (!numericRegex.test(value)) {
        errors.barcode.textContent = "Շտրիխ կոդը պետք է պարունակի միայն թվեր։";
        return false;
    }
    errors.barcode.textContent = "";
    return true;
}

function validateName() {
    const value = nameInput.value.trim();
    if (value === "") {
        errors.name.textContent = "Անվանումը պարտադիր է։";
        return false;
    }
    if (value.length > 50) {
        errors.name.textContent = "Անվանումը չպետք է գերազանցի 50 նիշ։";
        return false;
    }
    errors.name.textContent = "";
    return true;
}

function validateQuantity() {
    const value = quantityInput.value.trim();
    if (value === "") {
        errors.quantity.textContent = "Քանակը պարտադիր է։";
        return false;
    }
    const num = Number(value);
    if (isNaN(num)) {
        errors.quantity.textContent = "Քանակը պետք է լինի թիվ։";
        return false;
    }
    const [intPart, decPart] = value.split(".");
    if (intPart.length > 8 || (decPart && decPart.length > 3)) {
        errors.quantity.textContent = "Քանակը պետք է լինի առավելագույնը 8 նիշ ամբողջ մասում և 3 նիշ տասնորդականում։";
        return false;
    }
    errors.quantity.textContent = "";
    return true;
}

function validatePrice() {
    const value = priceInput.value.trim();
    if (value === "") {
        errors.price.textContent = "Գինը պարտադիր է։";
        return false;
    }
    const num = Number(value);
    if (isNaN(num)) {
        errors.price.textContent = "Գինը պետք է լինի թիվ։";
        return false;
    }
    const [intPart, decPart] = value.split(".");
    if (intPart.length > 8 || (decPart && decPart.length > 2)) {
        errors.price.textContent = "Գինը պետք է լինի առավելագույնը 8 նիշ ամբողջ մասում և 2 նիշ տասնորդականում։";
        return false;
    }
    errors.price.textContent = "";
    return true;
}

function validatePrice0() {
    const value = price0Input.value.trim();
    if (value === "") {
        errors.price0.textContent = "Գինը պարտադիր է։";
        return false;
    }
    const num = Number(value);
    if (isNaN(num)) {
        errors.price0.textContent = "Գինը պետք է լինի թիվ։";
        return false;
    }
    const [intPart, decPart] = value.split(".");
    if (intPart.length > 8 || (decPart && decPart.length > 2)) {
        errors.price0.textContent = "Գինը պետք է լինի առավելագույնը 8 նիշ ամբողջ մասում և 2 նիշ տասնորդականում։";
        return false;
    }
    errors.price0.textContent = "";
    return true;
}

function validateAll() {
    const isValidBarcode = validateBarcode();
    const isValidName = validateName();
    const isValidQuantity = validateQuantity();
    const isValidPrice = validatePrice();
    const isValidPrice0 = validatePrice0();

    return isValidBarcode && isValidName && isValidQuantity && isValidPrice && isValidPrice0;
}

function tryAutoSubmit() {
    const submitBtn = document.getElementById("submit")
    if (validateAll()) {
        submitBtn.style.display = "block"
        submitBtn.focus();
        orderapranq_newrow();
    }
}

barcodeInput.addEventListener('input', () => {
    validateBarcode();
    //tryAutoSubmit()
});

nameInput.addEventListener('input', () => {
    validateName();
    //tryAutoSubmit()
});

quantityInput.addEventListener('input', () => {
    validateQuantity();
    //tryAutoSubmit()
});

priceInput.addEventListener('input', () => {
    validatePrice();
    //tryAutoSubmit()
});
price0Input.addEventListener('input', () => {
    validatePrice0();
    //tryAutoSubmit()
});

form.addEventListener('submit', function (e) {

    orderapranq_newrow();

});*/
//---------
get_lastorder(); 